


'===============================================================================
'                                   ATMEGA_328P
'===============================================================================
  $map       '      Bascom
  $regfile = "m328pdef.dat"       'http://www.atmel.com/images/Atmel-8271-8-bit-AVR-Microcontroller-ATmega48A-48PA-88A-88PA-168A-168PA-328-328P_datasheet_Complete.pdf
  $crystal = 8000000
  $framesize = 64       '       
  $hwstack = 64       '   
  $swstack = 64       '   

'===============================================================================
'                                   i2c
'===============================================================================
  Lcd__pcf8574 Alias 0
  Ds3231 Alias 1

  $lib "i2c-multibus.lib"
  Config I2cbus = 0 , Scl = Portc.5 , Sda = Portc.4
  Config I2cbus = 1 , Scl = Portc.1 , Sda = Portc.0
  Config I2cdelay = 10
  I2cbus = 0
  I2cinit
  Waitms 50
  I2cbus = 1
  I2cinit
  Waitms 50

'===============================================================================
'                                  
'===============================================================================
  I2cbus = Lcd__pcf8574
  $lib "multi_i2c_lcd_HD44780_pcf8574.lib"
  Config Lcd = 20 * 4       '   LCD

'--------------------         ---------------------
  Dim _backlight As Byte : _backlight = 0       '    
   Alias _backlight
  Dim _lcd_e As Byte : _lcd_e = 192       ' !!!  ,    !!!

  Const Pcf8574_lcd = &H40       '  PCF8574

'+-----------------------------------------------------------------+
'|             |  PCF8574,PCF8574N, PCF8575 |  PCF8574A, PCF8574AP |
'|-------------|----------------------------|----------------------|
'|  A0  A1  A2 |     Write   |     Read     |    Write  |   Read   |
'|-------------|-------------|--------------|-----------|----------|
'|  0   0   0  |      &H40   |     &H41     |    &H70   |   &H71   |
'|  1   0   0  |      &H42   |     &H43     |    &H72   |   &H73   |
'|  0   1   0  |      &H44   |     &H45     |    &H74   |   &H75   |
'|  1   1   0  |      &H46   |     &H47     |    &H76   |   &H77   |
'|  0   0   1  |      &H48   |     &H49     |    &H78   |   &H79   |
'|  1   0   1  |      &H4A   |     &H4B     |    &H7A   |   &H7B   |
'|  0   1   1  |      &H4C   |     &H4D     |    &H7C   |   &H7D   |
'|  1   1   1  |      &H4E   |     &H4F     |    &H7E   |   &H7F   |
'+-----------------------------------------------------------------+

'----------------     PCF8574x   ----------------------------
  Const Pcf_rs = 6       ' RS
  Const Pcf_bl = 7       ' 
  Const Pcf_e2 = 4       ' 
  Const Pcf_e1 = 5       '   
 '-----------------------------------------
  Const Pcf_d4 = 0       ' D4
  Const Pcf_d5 = 1       ' D5
  Const Pcf_d6 = 2       ' D6
  Const Pcf_d7 = 3       ' D7


  Initlcd       '   LCD
  Cursor Off       '  
  Cls       '  ,   ,   

'-----------------------  _--------------------------------
 Deflcdchar 1 , 12 , 18 , 18 , 12 , 32 , 32 , 32 , 32       ' 
' Deflcdchar 5 , 14 , 10 , 10 , 10 , 14 , 31 , 31 , 14       '
'  Deflcdchar 6 , 4 , 5 , 15 , 20 , 4 , 14 , 10 , 27           '
'  Deflcdchar 7 , 232 , 244 , 232 , 227 , 228 , 228 , 227 , 224       ' 
'  Deflcdchar 8 , 2 , 6 , 30 , 30 , 30 , 6 , 2 , 32            '
'  Deflcdchar 9 , 32 , 25 , 11 , 4 , 26 , 19 , 32 , 32        ' 
'  Deflcdchar 10 , 9 , 26 , 28 , 27 , 28 , 26 , 9 , 32         '  
'  Deflcdchar 1 , 31 , 27 , 19 , 27 , 27 , 17 , 31 , 31       ' 1
'  Deflcdchar 2 , 31 , 17 , 29 , 27 , 23 , 17 , 31 , 31       ' 2
'  Deflcdchar 3 , 31 , 17 , 29 , 27 , 29 , 17 , 31 , 31       ' 3
'  Deflcdchar 4 , 31 , 21 , 21 , 17 , 29 , 29 , 31 , 31       ' 4
'  Deflcdchar 5 , 31 , 17 , 23 , 17 , 29 , 17 , 31 , 31       ' 5
'  Deflcdchar 6 , 31 , 17 , 23 , 17 , 21 , 17 , 31 , 31       ' 6
'  Deflcdchar 7 , 31 , 17 , 29 , 27 , 23 , 23 , 31 , 31       ' 7
'  Deflcdchar 8 , 31 , 17 , 21 , 17 , 21 , 17 , 31 , 31       ' 8
'  Deflcdchar 9 , 31 , 17 , 21 , 17 , 29 , 17 , 31 , 31       ' 9
'  Deflcdchar 0 , 31 , 17 , 21 , 21 , 21 , 17 , 31 , 31       ' 0

'===============================================================================
'                                      
'===============================================================================
  Dim Val_long As Long
  Dim Val_str As String * 10

'===============================================================================
'                                  
'===============================================================================
  Declare Sub Print_lcd(byval Copy_ As Byte , Byval Copy_ As Byte , Byval Copy_buffer_lcd As String)       '      LCD HD44780

'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
'                                           
'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

  I2cbus = Lcd__pcf8574
  Reset        '  ,  Reset, ..,    PCF8574  
  Print_lcd 1 , 1 , "  "
  Print_lcd 2 , 1 , " LCD    i2c "
  Print_lcd 3 , 1 , "Atmega328P + Ds3231 "
  Print_lcd 4 , 1 , "    PCF8574    "
  Wait 2
  Cls

'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\

'--------------       ----------------------
'  Enable Int0
'------------        --------------------
'  Enable Interrupts
'-------------------------------------------------------------------------------

'\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\
'===============================================================================
'                                     
  _:
'===============================================================================

      Incr Val_long

      Val_str = Str(val_long)

      Val_str = Format(val_str , "       0")
      Val_str = Val_str + Chr(1) + "C"

      Locate 1 , 1
      Lcd Val_str


      Waitms 100
     nop

'   Idle       '     
'===============================================================================
  Goto _
 End
'===============================================================================
'                                       
'===============================================================================



'===============================================================================
'                LCD HD44780
'===============================================================================
  Sub Print_lcd(byval Copy_ As Byte , Byval Copy_ As Byte , Byval Copy_buffer_lcd As String)       '      LCD HD44780
'-------------------------------------------------------------------------------
    Local _ As Byte , _lcd_print As Byte , _ As Byte , __lcd As Byte
    Local  As Byte ,  As Byte
    Local _str As String * 1 , _lcd_str As String * 1 , __lcd_str As String * 20

     = Copy_
     = Copy_
    __lcd_str = ""

    _ = Len(copy_buffer_lcd)       '    
    If _ = 0 Then       ' Ec   "0",   
        Exit Sub       '    
    End If

    For _lcd_print = 1 To _       '     
        _str = Mid(copy_buffer_lcd , _lcd_print , 1)       '   1    
        _ = Asc(_str)       '    

        If _ > 191 Then
            __lcd = Lookup(_ , Cp1251_to_lcd_hd44780)       '      (  )
            _lcd_str = Chr(__lcd)       '     LCD   (  )
          Else
            _lcd_str = _str
        End If

        __lcd_str = __lcd_str + _lcd_str       '      LCD
    Next _lcd_print       '      

    Locate  ,        '     
    Lcd __lcd_str       '     LCD
'-------------------------------------------------------------------------------
  End Sub
'===============================================================================



'===============================================================================
'                Cp1251
'                   LCD
'===============================================================================
  Cp1251_to_lcd_hd44780:
'---------------   128   -------------------------------------------
    Data &H00 , &H01 , &H02 , &H03 , &H04 , &H05 , &H06 , &H07 , &H08 , &H09
    Data &H0A , &H0B , &H0C , &H0D , &H0E , &H0F , &H10 , &H11 , &H12 , &H13
    Data &H14 , &H15 , &H16 , &H17 , &H18 , &H19 , &H1A , &H1B , &H1C , &H1D
    Data &H1E , &H1F , &H20 , &H21 , &H22 , &H23 , &H24 , &H25 , &H26 , &H27
    Data &H28 , &H29 , &H2A , &H2B , &H2C , &H2D , &H2E , &H2F , &H30 , &H31
    Data &H32 , &H33 , &H34 , &H35 , &H36 , &H37 , &H38 , &H39 , &H3A , &H3B
    Data &H3C , &H3D , &H3E , &H3F , &H40 , &H41 , &H42 , &H43 , &H44 , &H45
    Data &H46 , &H47 , &H48 , &H49 , &H4A , &H4B , &H4C , &H4D , &H4E , &H4F
    Data &H50 , &H51 , &H52 , &H53 , &H54 , &H55 , &H56 , &H57 , &H58 , &H59
    Data &H5A , &H5B , &H20 , &H5D , &H5E , &H5F , &H60 , &H61 , &H62 , &H63
    Data &H64 , &H65 , &H66 , &H67 , &H68 , &H69 , &H6A , &H6B , &H6C , &H6D
    Data &H6E , &H6F , &H70 , &H71 , &H72 , &H73 , &H74 , &H75 , &H76 , &H77
    Data &H78 , &H79 , &H7A , &H5B , &H20 , &H5D , &HE9 , &H7F
'---------------   128   -------------------------------------------
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20 , &H20
    Data &H20 , &H20 , &HCB , &H20 , &H49 , &H69 , &H04 , &H20 , &HFE , &HEF
    Data &HA2 , &HCC , &H00 , &HC9 , &H20 , &H20 , &H20 , &H02 , &H00 , &H00
    Data &H00 , &H00 , &H00 , &H00 , &H00 , &H00 , &HB5 , &H4E , &H00 , &H00
    Data &H00 , &H00 , &H00 , &H00 , &H41 , &HA0 , &H42 , &HA1 , &HE0 , &H45
    Data &HA3 , &HA4 , &HA5 , &HA6 , &H4B , &HA7 , &H4D , &H48 , &H4F , &HA8
    Data &H50 , &H43 , &H54 , &HA9 , &HAA , &H58 , &HE1 , &HAB , &HAC , &HE2
    Data &HAD , &HAE , &H62 , &HAF , &HB0 , &HB1 , &H61 , &HB2 , &HB3 , &HB4
    Data &HE3 , &H65 , &HB6 , &HB7 , &HB8 , &HB9 , &HBA , &HBB , &HBC , &HBD
    Data &H6F , &HBE , &H70 , &H63 , &HBF , &H79 , &HE4 , &H78 , &HE5 , &HC0
    Data &HC1 , &HE6 , &HC2 , &HC3 , &HC4 , &HC5 , &HC6 , &HC7
'===============================================================================